/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.inventory;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.Validate;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftLegacy;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class CraftItemFactory
implements ItemFactory {
    static final Color DEFAULT_LEATHER_COLOR = Color.fromRGB(10511680);
    private static final CraftItemFactory instance = new CraftItemFactory();

    private CraftItemFactory() {
    }

    @Override
    public boolean isApplicable(ItemMeta meta, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return this.isApplicable(meta, itemstack.getType());
    }

    @Override
    public boolean isApplicable(ItemMeta meta, Material type) {
        if ((type = CraftLegacy.fromLegacy(type)) == null || meta == null) {
            return false;
        }
        if (!(meta instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("Meta of " + meta.getClass().toString() + " not created by " + CraftItemFactory.class.getName());
        }
        return ((CraftMetaItem)meta).applicableTo(type);
    }

    @Override
    public ItemMeta getItemMeta(Material material) {
        Validate.notNull((Object)material, (String)"Material cannot be null", (Object[])new Object[0]);
        return this.getItemMeta(material, null);
    }

    private ItemMeta getItemMeta(Material material, CraftMetaItem meta) {
        material = CraftLegacy.fromLegacy(material);
        try {
            return switch (material) {
                case Material.AIR -> null;
                case Material.WRITTEN_BOOK -> {
                    if (meta instanceof CraftMetaBookSigned) {
                        yield meta;
                    }
                    yield new CraftMetaBookSigned(meta);
                }
                case Material.WRITABLE_BOOK -> {
                    if (meta != null && meta.getClass().equals(CraftMetaBook.class)) {
                        yield meta;
                    }
                    yield new CraftMetaBook(meta);
                }
                case Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD, Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD, Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL, Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL, Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD -> {
                    if (meta instanceof CraftMetaSkull) {
                        yield meta;
                    }
                    yield new CraftMetaSkull(meta);
                }
                case Material.LEATHER_HELMET, Material.LEATHER_HORSE_ARMOR, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS -> {
                    if (meta instanceof CraftMetaLeatherArmor) {
                        yield meta;
                    }
                    yield new CraftMetaLeatherArmor(meta);
                }
                case Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION, Material.TIPPED_ARROW -> {
                    if (meta instanceof CraftMetaPotion) {
                        yield meta;
                    }
                    yield new CraftMetaPotion(meta);
                }
                case Material.FILLED_MAP -> {
                    if (meta instanceof CraftMetaMap) {
                        yield meta;
                    }
                    yield new CraftMetaMap(meta);
                }
                case Material.FIREWORK_ROCKET -> {
                    if (meta instanceof CraftMetaFirework) {
                        yield meta;
                    }
                    yield new CraftMetaFirework(meta);
                }
                case Material.FIREWORK_STAR -> {
                    if (meta instanceof CraftMetaCharge) {
                        yield meta;
                    }
                    yield new CraftMetaCharge(meta);
                }
                case Material.ENCHANTED_BOOK -> {
                    if (meta instanceof CraftMetaEnchantedBook) {
                        yield meta;
                    }
                    yield new CraftMetaEnchantedBook(meta);
                }
                case Material.BLACK_BANNER, Material.BLACK_WALL_BANNER, Material.BLUE_BANNER, Material.BLUE_WALL_BANNER, Material.BROWN_BANNER, Material.BROWN_WALL_BANNER, Material.CYAN_BANNER, Material.CYAN_WALL_BANNER, Material.GRAY_BANNER, Material.GRAY_WALL_BANNER, Material.GREEN_BANNER, Material.GREEN_WALL_BANNER, Material.LIGHT_BLUE_BANNER, Material.LIGHT_BLUE_WALL_BANNER, Material.LIGHT_GRAY_BANNER, Material.LIGHT_GRAY_WALL_BANNER, Material.LIME_BANNER, Material.LIME_WALL_BANNER, Material.MAGENTA_BANNER, Material.MAGENTA_WALL_BANNER, Material.ORANGE_BANNER, Material.ORANGE_WALL_BANNER, Material.PINK_BANNER, Material.PINK_WALL_BANNER, Material.PURPLE_BANNER, Material.PURPLE_WALL_BANNER, Material.RED_BANNER, Material.RED_WALL_BANNER, Material.WHITE_BANNER, Material.WHITE_WALL_BANNER, Material.YELLOW_BANNER, Material.YELLOW_WALL_BANNER -> {
                    if (meta instanceof CraftMetaBanner) {
                        yield meta;
                    }
                    yield new CraftMetaBanner(meta);
                }
                case Material.AXOLOTL_SPAWN_EGG, Material.BAT_SPAWN_EGG, Material.BEE_SPAWN_EGG, Material.BLAZE_SPAWN_EGG, Material.CAT_SPAWN_EGG, Material.CAVE_SPIDER_SPAWN_EGG, Material.CHICKEN_SPAWN_EGG, Material.COD_SPAWN_EGG, Material.COW_SPAWN_EGG, Material.CREEPER_SPAWN_EGG, Material.DOLPHIN_SPAWN_EGG, Material.DONKEY_SPAWN_EGG, Material.DROWNED_SPAWN_EGG, Material.ELDER_GUARDIAN_SPAWN_EGG, Material.ENDERMAN_SPAWN_EGG, Material.ENDERMITE_SPAWN_EGG, Material.EVOKER_SPAWN_EGG, Material.FOX_SPAWN_EGG, Material.GHAST_SPAWN_EGG, Material.GLOW_SQUID_SPAWN_EGG, Material.GOAT_SPAWN_EGG, Material.GUARDIAN_SPAWN_EGG, Material.HOGLIN_SPAWN_EGG, Material.HORSE_SPAWN_EGG, Material.HUSK_SPAWN_EGG, Material.LLAMA_SPAWN_EGG, Material.MAGMA_CUBE_SPAWN_EGG, Material.MOOSHROOM_SPAWN_EGG, Material.MULE_SPAWN_EGG, Material.OCELOT_SPAWN_EGG, Material.PANDA_SPAWN_EGG, Material.PARROT_SPAWN_EGG, Material.PHANTOM_SPAWN_EGG, Material.PIGLIN_BRUTE_SPAWN_EGG, Material.PIGLIN_SPAWN_EGG, Material.PIG_SPAWN_EGG, Material.PILLAGER_SPAWN_EGG, Material.POLAR_BEAR_SPAWN_EGG, Material.PUFFERFISH_SPAWN_EGG, Material.RABBIT_SPAWN_EGG, Material.RAVAGER_SPAWN_EGG, Material.SALMON_SPAWN_EGG, Material.SHEEP_SPAWN_EGG, Material.SHULKER_SPAWN_EGG, Material.SILVERFISH_SPAWN_EGG, Material.SKELETON_HORSE_SPAWN_EGG, Material.SKELETON_SPAWN_EGG, Material.SLIME_SPAWN_EGG, Material.SPIDER_SPAWN_EGG, Material.SQUID_SPAWN_EGG, Material.STRAY_SPAWN_EGG, Material.STRIDER_SPAWN_EGG, Material.TRADER_LLAMA_SPAWN_EGG, Material.TROPICAL_FISH_SPAWN_EGG, Material.TURTLE_SPAWN_EGG, Material.VEX_SPAWN_EGG, Material.VILLAGER_SPAWN_EGG, Material.VINDICATOR_SPAWN_EGG, Material.WANDERING_TRADER_SPAWN_EGG, Material.WITCH_SPAWN_EGG, Material.WITHER_SKELETON_SPAWN_EGG, Material.WOLF_SPAWN_EGG, Material.ZOGLIN_SPAWN_EGG, Material.ZOMBIE_HORSE_SPAWN_EGG, Material.ZOMBIE_SPAWN_EGG, Material.ZOMBIE_VILLAGER_SPAWN_EGG, Material.ZOMBIFIED_PIGLIN_SPAWN_EGG -> {
                    if (meta instanceof CraftMetaSpawnEgg) {
                        yield meta;
                    }
                    yield new CraftMetaSpawnEgg(meta);
                }
                case Material.ARMOR_STAND -> {
                    if (meta instanceof CraftMetaArmorStand) {
                        yield meta;
                    }
                    yield new CraftMetaArmorStand(meta);
                }
                case Material.KNOWLEDGE_BOOK -> {
                    if (meta instanceof CraftMetaKnowledgeBook) {
                        yield meta;
                    }
                    yield new CraftMetaKnowledgeBook(meta);
                }
                case Material.FURNACE, Material.CHEST, Material.TRAPPED_CHEST, Material.JUKEBOX, Material.DISPENSER, Material.DROPPER, Material.ACACIA_SIGN, Material.ACACIA_WALL_SIGN, Material.BIRCH_SIGN, Material.BIRCH_WALL_SIGN, Material.CRIMSON_SIGN, Material.CRIMSON_WALL_SIGN, Material.DARK_OAK_SIGN, Material.DARK_OAK_WALL_SIGN, Material.JUNGLE_SIGN, Material.JUNGLE_WALL_SIGN, Material.OAK_SIGN, Material.OAK_WALL_SIGN, Material.SPRUCE_SIGN, Material.SPRUCE_WALL_SIGN, Material.WARPED_SIGN, Material.WARPED_WALL_SIGN, Material.SPAWNER, Material.BREWING_STAND, Material.ENCHANTING_TABLE, Material.COMMAND_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK, Material.BEACON, Material.DAYLIGHT_DETECTOR, Material.HOPPER, Material.COMPARATOR, Material.SHIELD, Material.STRUCTURE_BLOCK, Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX, Material.ENDER_CHEST, Material.BARREL, Material.BELL, Material.BLAST_FURNACE, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.JIGSAW, Material.LECTERN, Material.SMOKER, Material.BEEHIVE, Material.BEE_NEST, Material.SCULK_SENSOR -> new CraftMetaBlockState(meta, material);
                case Material.TROPICAL_FISH_BUCKET -> {
                    if (meta instanceof CraftMetaTropicalFishBucket) {
                        yield meta;
                    }
                    yield new CraftMetaTropicalFishBucket(meta);
                }
                case Material.AXOLOTL_BUCKET -> {
                    if (meta instanceof CraftMetaAxolotlBucket) {
                        yield meta;
                    }
                    yield new CraftMetaAxolotlBucket(meta);
                }
                case Material.CROSSBOW -> {
                    if (meta instanceof CraftMetaCrossbow) {
                        yield meta;
                    }
                    yield new CraftMetaCrossbow(meta);
                }
                case Material.SUSPICIOUS_STEW -> {
                    if (meta instanceof CraftMetaSuspiciousStew) {
                        yield meta;
                    }
                    yield new CraftMetaSuspiciousStew(meta);
                }
                case Material.COD_BUCKET, Material.PUFFERFISH_BUCKET, Material.SALMON_BUCKET, Material.ITEM_FRAME, Material.GLOW_ITEM_FRAME, Material.PAINTING -> {
                    if (meta instanceof CraftMetaEntityTag) {
                        yield meta;
                    }
                    yield new CraftMetaEntityTag(meta);
                }
                case Material.COMPASS -> {
                    if (meta instanceof CraftMetaCompass) {
                        yield meta;
                    }
                    yield new CraftMetaCompass(meta);
                }
                case Material.BUNDLE -> {
                    if (meta instanceof CraftMetaBundle) {
                        yield meta;
                    }
                    yield new CraftMetaBundle(meta);
                }
                default -> new CraftMetaItem(meta);
            };
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.err.println(ex.getMessage() + " (CraftItemFactory.java#getItemMeta(Material,CraftMetaItem))");
            return null;
        }
    }

    @Override
    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        if (meta1 == meta2) {
            return true;
        }
        if (meta1 != null && !(meta1 instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("First meta of " + meta1.getClass().getName() + " does not belong to " + CraftItemFactory.class.getName());
        }
        if (meta2 != null && !(meta2 instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("Second meta " + meta2.getClass().getName() + " does not belong to " + CraftItemFactory.class.getName());
        }
        if (meta1 == null) {
            return ((CraftMetaItem)meta2).isEmpty();
        }
        if (meta2 == null) {
            return ((CraftMetaItem)meta1).isEmpty();
        }
        return this.equals((CraftMetaItem)meta1, (CraftMetaItem)meta2);
    }

    boolean equals(CraftMetaItem meta1, CraftMetaItem meta2) {
        return meta1.equalsCommon(meta2) && meta1.notUncommon(meta2) && meta2.notUncommon(meta1);
    }

    public static CraftItemFactory instance() {
        return instance;
    }

    @Override
    public ItemMeta asMetaFor(ItemMeta meta, ItemStack stack) {
        Validate.notNull((Object)stack, (String)"Stack cannot be null", (Object[])new Object[0]);
        return this.asMetaFor(meta, stack.getType());
    }

    @Override
    public ItemMeta asMetaFor(ItemMeta meta, Material material) {
        Validate.notNull((Object)material, (String)"Material cannot be null", (Object[])new Object[0]);
        if (!(meta instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("Meta of " + (meta != null ? meta.getClass().toString() : "null") + " not created by " + CraftItemFactory.class.getName());
        }
        return this.getItemMeta(material, (CraftMetaItem)meta);
    }

    @Override
    public Color getDefaultLeatherColor() {
        return DEFAULT_LEATHER_COLOR;
    }

    @Override
    public ItemStack createItemStack(String input) throws IllegalArgumentException {
        try {
            ItemParser arg = new ItemParser(new StringReader(input), false).m_121032_();
            Item item = arg.m_121014_();
            net.minecraft.world.item.ItemStack nmsItemStack = new net.minecraft.world.item.ItemStack((ItemLike)item);
            CompoundTag nbt = arg.m_121018_();
            if (nbt != null) {
                nmsItemStack.m_41751_(nbt);
            }
            return CraftItemStack.asCraftMirror(nmsItemStack);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse ItemStack: " + input, ex);
        }
    }

    @Override
    public Material updateMaterial(ItemMeta meta, Material material) throws IllegalArgumentException {
        return ((CraftMetaItem)meta).updateMaterial(material);
    }

    static {
        ConfigurationSerialization.registerClass(CraftMetaItem.SerializableMeta.class);
    }
}

